/*******************************************************************************
FileName:       SimpleIO-UM_CppExampleCode.cpp
Processor:      Windows PC
Compiler:       Microsoft Visual C++ 2010

Project Notes:	To run this project, right-click on the project you want to run and
                select the "Set as StartUp Project" menu item.   After this, choose 
                the "Debug" menu option and select the "Start Without Debugging" 
                menu item.  A command window should be shown with the corresponding 
                program output.  

Copyright  2012-2014 released Microchip Technology Inc.  All rights reserved.
 
MICROCHIP SOFTWARE NOTICE AND DISCLAIMER:  You may use this software, and any 
derivatives created by any person or entity by or on your behalf, exclusively 
with Microchips products.  Microchip and its licensors retain all ownership 
and intellectual property rights in the accompanying software and in all 
derivatives hereto.  
 
This software and any accompanying information is for suggestion only.  It does 
not modify Microchips standard warranty for its products.  You agree that you 
are solely responsible for testing the software and determining its suitability.  
Microchip has no obligation to modify, test, certify, or support the software.

THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS".  NO WARRANTIES, WHETHER EXPRESS, 
IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF 
NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO 
THIS SOFTWARE, ITS INTERACTION WITH MICROCHIPS PRODUCTS, COMBINATION WITH ANY 
OTHER PRODUCTS, OR USE IN ANY APPLICATION. 

IN NO EVENT, WILL MICROCHIP BE LIABLE, WHETHER IN CONTRACT, WARRANTY, TORT 
(INCLUDING NEGLIGENCE OR BREACH OF STATUTORY DUTY), STRICT LIABILITY, INDEMNITY, 
CONTRIBUTION, OR OTHERWISE, FOR ANY INDIRECT, SPECIAL, PUNITIVE, EXEMPLARY, 
INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, FOR COST OR EXPENSE OF ANY KIND WHATSOEVER 
RELATED TO THE SOFTWARE, HOWSOEVER CAUSED, EVEN IF MICROCHIP HAS BEEN ADVISED OF THE 
POSSIBILITY OR THE DAMAGES ARE FORESEEABLE.  TO THE FULLEST EXTENT ALLOWABLE BY LAW, 
MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL 
NOT EXCEED THE AMOUNT OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP 
FOR THIS SOFTWARE.

MICROCHIP PROVIDES THIS SOFTWARE CONDITIONALLY UPON YOUR ACCEPTANCE OF THESE TERMS.


*******************************************************************************/

#include "StdAfx.h";
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <string>
#include <Windows.h>		 //Must include this header in program.
 
using namespace std;
 
 
 
int main( int argc, char * argv[] )
{
    //Variables
    int userSelection = 0;        //User input when requested for main menu
    static unsigned int  mcp2200_VID = 0x04D8;   //VID for MCP2200
    static unsigned int  mcp2200_PID = 0x00DF;   //PID for MCP2200
    bool connectedStatus = false;                //Connection status of MCP2200
    unsigned int result = 0;      //Result of function calls with uint returned
 
    //STEP 1: Get handle to DLL 
    HINSTANCE DLL_handle = LoadLibrary(TEXT("SimpleIO-UM.dll"));
    //Print result of LoadLibrary call
    if( DLL_handle == NULL )    //If it is null, LoadLibrary call failed
    {
        DWORD error = GetLastError();
        if(error == 126 )		//This means the DLL was not found
        {
            cout << "There was an error finding the specified DLL.  \n" 
                << "Please check the name and path specified.\n";
        }
        else
        {
            cout << "Loading of the DLL failed\n";
            cout << "The error was:   " << error << "\n\n";
        }
        return -1;
    }
    else
    {
        cout << "DLL has been loaded\n\n";
    }
    
    //STEP 2: Get pointer to the function in the DLL
    FARPROC lpfnGetProcessID0 = GetProcAddress(HMODULE (DLL_handle),"InitMCP2200");
    FARPROC lpfnGetProcessID1 = GetProcAddress(HMODULE (DLL_handle),"IsConnected");

    //STEP 3: Define the Function in the DLL for reuse. 
    //(Prototyping the DLL's function) Use "stdcall 
    typedef void (__stdcall * pICFUNC0)(unsigned int, unsigned int);
    typedef bool (__stdcall * pICFUNC1)();
    //Same step as above. 
    pICFUNC0 DLL_InitMCP2200 = pICFUNC0(lpfnGetProcessID0);
    pICFUNC1 DLL_IsConnected = pICFUNC1(lpfnGetProcessID1);
 
    //STEP 4: Call the DLL function through the prototype name given in step 3
    //Initialize the MCP2200  NOTE: Must be plugged in when program is ran
    DLL_InitMCP2200(mcp2200_VID, mcp2200_PID);
    cout << "The MCP2200 was successfully initialized.\n";
    //Check connection status.
    connectedStatus = DLL_IsConnected();
    if(connectedStatus == true)
        cout <<"The device is CONNECTED";
    else
        cout << "The device is DISCONNECTED";
    cout << "\n\n";
 
    //STEP 5: Release the DLL 
    FreeLibrary(DLL_handle);
     
    return 0;
}


