﻿/*******************************************************************************
FileName:       Program.cs
Processor:      Windows PC
Compiler:       Microsoft Visual C# 2010
Project Notes:	To run this project, right-click on the project you want to run and
                select the "Set as StartUp Project" menu item.   After this, choose 
                the "Debug" menu option and select the "Start Without Debugging" 
                menu item.  A command window should be shown with the corresponding 
                program output.  

Copyright © 2012-2014 released Microchip Technology Inc.  All rights reserved. 
 
MICROCHIP SOFTWARE NOTICE AND DISCLAIMER:  You may use this software, and any 
derivatives created by any person or entity by or on your behalf, exclusively 
with Microchip’s products.  Microchip and its licensors retain all ownership 
and intellectual property rights in the accompanying software and in all 
derivatives hereto.  
This software and any accompanying information is for suggestion only.  It does 
not modify Microchip’s standard warranty for its products.  You agree that you 
are solely responsible for testing the software and determining its suitability.  
Microchip has no obligation to modify, test, certify, or support the software.
THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS".  NO WARRANTIES, WHETHER EXPRESS, 
IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF 
NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO 
THIS SOFTWARE, ITS INTERACTION WITH MICROCHIP’S PRODUCTS, COMBINATION WITH ANY 
OTHER PRODUCTS, OR USE IN ANY APPLICATION. 
IN NO EVENT, WILL MICROCHIP BE LIABLE, WHETHER IN CONTRACT, WARRANTY, TORT 
(INCLUDING NEGLIGENCE OR BREACH OF STATUTORY DUTY), STRICT LIABILITY, INDEMNITY, 
CONTRIBUTION, OR OTHERWISE, FOR ANY INDIRECT, SPECIAL, PUNITIVE, EXEMPLARY, 
INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, FOR COST OR EXPENSE OF ANY KIND WHATSOEVER 
RELATED TO THE SOFTWARE, HOWSOEVER CAUSED, EVEN IF MICROCHIP HAS BEEN ADVISED OF THE 
POSSIBILITY OR THE DAMAGES ARE FORESEEABLE.  TO THE FULLEST EXTENT ALLOWABLE BY LAW, 
MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL 
NOT EXCEED THE AMOUNT OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP 
FOR THIS SOFTWARE.
MICROCHIP PROVIDES THIS SOFTWARE CONDITIONALLY UPON YOUR ACCEPTANCE OF THESE TERMS.
 

*******************************************************************************/
using System;
using System.Runtime.InteropServices;	//Must use this namespace for DLL imports!	
 
namespace SimpleIO_UM_CSExampleCode
{
    class Program       
    {
        //Declarations to import the desired functions from the DLL
        [DllImport(@"SIMPLEIO-UM.DLL", EntryPoint = "InitMCP2200", SetLastError = true,
        CharSet = CharSet.Unicode, ExactSpelling = true,
        CallingConvention = CallingConvention.StdCall)]
        public static extern bool DLL_InitMCP2200(uint vid, uint pid);

        [DllImport(@"SIMPLEIO-UM.DLL", EntryPoint = "IsConnected", SetLastError = true,
        CharSet = CharSet.Unicode, ExactSpelling = true,
        CallingConvention = CallingConvention.StdCall)]
        public static extern bool DLL_IsConnected();

        //Variable initialization
        static uint mcp2200_VID = 0x04D8;    //VID for MCP2200
        static uint mcp2200_PID = 0x00DF;    //PID for MCP2200

        //Main function to run all tests
        static int Main(string[] args)
        {
            //Call the DLL function – InitMCP2200(uint VID, uint PID);
            DLL_InitMCP2200(mcp2200_VID, mcp2200_PID);
            Console.Out.Write("Example:\t The MCP2200 was initialized.\n");

            //Call the DLL function – IsConnected() to test connection status
            bool connectedStatus = DLL_IsConnected();
            if (connectedStatus == true)
                Console.Out.WriteLine("2. Pass:\t The device is CONNECTED");
            else
            {
                Console.Out.WriteLine("2. Fail:\t The device is DISCONNECTED");
            }
            return 0;
        }
    }
}

