unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ComCtrls, LCLType, ExtCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    BaudRateEdit: TEdit;
    Button1: TButton;
    AllOnButton: TButton;
    AllOffButton: TButton;
    GP0CheckBox: TCheckBox;
    GP1CheckBox: TCheckBox;
    GP2CheckBox: TCheckBox;
    GP3CheckBox: TCheckBox;
    GP4CheckBox: TCheckBox;
    GP5CheckBox: TCheckBox;
    GP6CheckBox: TCheckBox;
    GP7CheckBox: TCheckBox;
    ConnectGroupBox: TGroupBox;
    FlowControlCombo: TComboBox;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    IOMap0Edit: TEdit;
    IOMap1Edit: TEdit;
    IOMap2Edit: TEdit;
    IOMap3Edit: TEdit;
    IOMap4Edit: TEdit;
    IOMap5Edit: TEdit;
    IOMap6Edit: TEdit;
    IOMap7Edit: TEdit;
    Label1: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    ProductIDEdit: TEdit;
    RxLEDModeCombo: TComboBox;
    StatusBar: TStatusBar;
    TxLEDModeCombo: TComboBox;
    VendorIDEdit: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure AllOnButtonClick(Sender: TObject);
    procedure AllOffButtonClick(Sender: TObject);
    procedure GP0CheckBoxChange(Sender: TObject);
    procedure GP1CheckBoxChange(Sender: TObject);
    procedure GP2CheckBoxChange(Sender: TObject);
    procedure GP3CheckBoxChange(Sender: TObject);
    procedure GP4CheckBoxChange(Sender: TObject);
    procedure GP5CheckBoxChange(Sender: TObject);
    procedure GP6CheckBoxChange(Sender: TObject);
    procedure GP7CheckBoxChange(Sender: TObject);
    procedure IOMap7EditKeyPress(Sender: TObject; var Key: char);
    procedure IOMap6EditKeyPress(Sender: TObject; var Key: char);
    procedure IOMap5EditKeyPress(Sender: TObject; var Key: char);
    procedure BaudRateEditChange(Sender: TObject);
    procedure IOMap4EditKeyPress(Sender: TObject; var Key: char);
    procedure IOMap3EditKeyPress(Sender: TObject; var Key: char);
    procedure IOMap2EditKeyPress(Sender: TObject; var Key: char);
    procedure IOMap1EditKeyPress(Sender: TObject; var Key: char);
    procedure IOMap0EditKeyPress(Sender: TObject; var Key: char);

  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

{$R *.lfm}

{ TForm1 }


const DLLNAME = 'SimpleIO-UM.dll';


procedure InitMCP2200(vid,pid:cardinal); stdcall; external DLLNAME;
function  IsConnected : boolean; stdcall; external DLLNAME;
function ConfigureMCP2200(IOMap:byte; BaudRateParam:cardinal; RxLEDMode: cardinal; TxLEDMode:cardinal; FLOW: boolean; ULOAD: boolean; SSPND: boolean; INVERT: boolean) : boolean; stdcall; external DLLNAME;
function SetPin(pin: cardinal) : boolean; stdcall; external DLLNAME;
function ClearPin(pin: cardinal) : boolean; stdcall; external DLLNAME;
function WritePort(PortValue: cardinal) : boolean; stdcall; external DLLNAME;
function ReadPortValue : cardinal; stdcall; external DLLNAME;

procedure TForm1.Button1Click(Sender: TObject);
 var
   vid, pid, BaudRateParam, RxLEDMode, TxLEDMode : cardinal;
   IOMap: byte;
   flow: boolean;
begin

  //VID
       try
          vid:=strtoint('$'+VendorIDEdit.Text);
       except
         ShowMessage('VendorID is non hexadecimal value!');
         exit;
       end;

  //PID
       try
           pid:=strtoint('$'+ProductIDEdit.Text);
       except
           ShowMessage('ProductID is non hexadecimal value!');
           exit;
       end;

       InitMCP2200(vid,pid);

  //IOMap
       IOMap:=0;
       if IOMap7Edit.Text='1' then IOMap:=$80;
       if IOMap6Edit.Text='1' then IOMap:=IOMap and $40;
       if IOMap5Edit.Text='1' then IOMap:=IOMap and $20;
       if IOMap4Edit.Text='1' then IOMap:=IOMap and $10;
       if IOMap3Edit.Text='1' then IOMap:=IOMap and $8;
       if IOMap2Edit.Text='1' then IOMap:=IOMap and $4;
       if IOMap1Edit.Text='1' then IOMap:=IOMap and $2;
       if IOMap0Edit.Text='1' then IOMap:=IOMap and $1;

   //baudrate
       try
           BaudRateParam:=strtoint(BaudRateEdit.Text);
       except
           ShowMessage('Baud Rate is non decimal value!');
           exit;
       end;

   //RxLEDMode
       case RxLEDModeCombo.ItemIndex of
         0: RxLEDMode:=0;
         1: RxLEDMode:=1;
         2: RxLEDMode:=3;
         3: RxLEDMode:=4;
         4: RxLEDMode:=5;
       end;

   //TxLEDMode
       case TxLEDModeCombo.ItemIndex of
         0: TxLEDMode:=0;
         1: TxLEDMode:=1;
         2: TxLEDMode:=3;
         3: TxLEDMode:=4;
         4: TxLEDMode:=5;
       end;

   //Flow Control
       if FlowControlCombo.ItemIndex=0 then flow:=false
       else flow:=true;

   //ConfigureMCP2200
     if ConfigureMCP2200(IOMap, BaudRateParam, RxLEDMode, TxLEDMode, flow, false, false, false) then statusbar.Panels.Items[0].Text:='Connected'
     else statusbar.Panels.Items[0].Text:='Not Connected';

   //WritePort (port=0)
     WritePort(0);

end;

procedure TForm1.AllOnButtonClick(Sender: TObject);
begin
     GP0CheckBox.Checked:=true;
     GP1CheckBox.Checked:=true;
     GP2CheckBox.Checked:=true;
     GP3CheckBox.Checked:=true;
     GP4CheckBox.Checked:=true;
     GP5CheckBox.Checked:=true;
     GP6CheckBox.Checked:=true;
     GP7CheckBox.Checked:=true;
end;

procedure TForm1.AllOffButtonClick(Sender: TObject);
begin
  GP0CheckBox.Checked:=false;
  GP1CheckBox.Checked:=false;
  GP2CheckBox.Checked:=false;
  GP3CheckBox.Checked:=false;
  GP4CheckBox.Checked:=false;
  GP5CheckBox.Checked:=false;
  GP6CheckBox.Checked:=false;
  GP7CheckBox.Checked:=false;
end;

procedure TForm1.GP0CheckBoxChange(Sender: TObject);
begin
   if GP0CheckBox.Checked then SetPin(0)
   else ClearPin(0);
end;

procedure TForm1.GP1CheckBoxChange(Sender: TObject);
begin
   if GP1CheckBox.Checked then SetPin(1)
   else ClearPin(1);
end;

procedure TForm1.GP2CheckBoxChange(Sender: TObject);
begin
   if GP2CheckBox.Checked then SetPin(2)
   else ClearPin(2);
end;

procedure TForm1.GP3CheckBoxChange(Sender: TObject);
begin
   if GP3CheckBox.Checked then SetPin(3)
   else ClearPin(3);
end;

procedure TForm1.GP4CheckBoxChange(Sender: TObject);
begin
   if GP4CheckBox.Checked then SetPin(4)
   else ClearPin(4);
end;

procedure TForm1.GP5CheckBoxChange(Sender: TObject);
begin
   if GP5CheckBox.Checked then SetPin(5)
   else ClearPin(5);
end;

procedure TForm1.GP6CheckBoxChange(Sender: TObject);
begin
   if GP6CheckBox.Checked then SetPin(6)
   else ClearPin(6);
end;

procedure TForm1.GP7CheckBoxChange(Sender: TObject);
begin
   if GP7CheckBox.Checked then SetPin(7)
   else ClearPin(7);
end;




procedure KeyPressHandler(Sender: TObject; var Key: char);
begin
  case key of
    '0'..'1' : if Sender is TEdit then with Sender as TEdit do clear;
     else  key:=#0;
  end;
end;

procedure TForm1.IOMap7EditKeyPress(Sender: TObject; var Key: char);
begin
 KeyPressHandler(sender,key);
 IOMap6Edit.SetFocus;
end;

procedure TForm1.IOMap6EditKeyPress(Sender: TObject; var Key: char);
begin
  KeyPressHandler(sender,key);
   IOMap5Edit.SetFocus;
end;

procedure TForm1.IOMap5EditKeyPress(Sender: TObject; var Key: char);
begin
  KeyPressHandler(sender,key);
  IOMap4Edit.SetFocus;
end;

procedure TForm1.BaudRateEditChange(Sender: TObject);
begin

end;

procedure TForm1.IOMap4EditKeyPress(Sender: TObject; var Key: char);
begin
  KeyPressHandler(sender,key);
  IOMap3Edit.SetFocus;
end;

procedure TForm1.IOMap3EditKeyPress(Sender: TObject; var Key: char);
begin
  KeyPressHandler(sender,key);
  IOMap2Edit.SetFocus;
end;

procedure TForm1.IOMap2EditKeyPress(Sender: TObject; var Key: char);
begin
  KeyPressHandler(sender,key);
  IOMap1Edit.SetFocus;
end;

procedure TForm1.IOMap1EditKeyPress(Sender: TObject; var Key: char);
begin
  KeyPressHandler(sender,key);
  IOMap0Edit.SetFocus;
end;

procedure TForm1.IOMap0EditKeyPress(Sender: TObject; var Key: char);
begin
  KeyPressHandler(sender,key);
end;



end.

